VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Chapter 17 Sample Code"
   ClientHeight    =   6000
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9270
   LinkTopic       =   "Form1"
   ScaleHeight     =   6000
   ScaleWidth      =   9270
   StartUpPosition =   3  'Windows Default
   Begin VB.ListBox lbMessages 
      Height          =   2205
      Left            =   120
      TabIndex        =   5
      Top             =   3600
      Width           =   9015
   End
   Begin VB.CommandButton UpdateProc 
      Caption         =   "Update products table via UpdateProductPrice stored procedure"
      Height          =   615
      Left            =   5040
      TabIndex        =   1
      Top             =   600
      Width           =   3735
   End
   Begin VB.CommandButton UpdateCommand 
      Caption         =   "Command: Update EMP set sal = sal * 1.10"
      Height          =   615
      Left            =   360
      TabIndex        =   0
      Top             =   600
      Width           =   3735
   End
   Begin VB.Frame Frame1 
      Caption         =   " Oracle "
      Height          =   2895
      Left            =   120
      TabIndex        =   2
      Top             =   240
      Width           =   4215
      Begin VB.CommandButton RecordSetField 
         Caption         =   "Field: select empno, ename, sal from emp"
         Height          =   615
         Left            =   240
         TabIndex        =   7
         Top             =   2040
         Width           =   3735
      End
      Begin VB.CommandButton RecordSet 
         Caption         =   "RecordSet: select empno, ename, sal from emp"
         Height          =   615
         Left            =   240
         TabIndex        =   6
         Top             =   1200
         Width           =   3735
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   " SQL Server "
      Height          =   2895
      Left            =   4800
      TabIndex        =   4
      Top             =   240
      Width           =   4215
   End
   Begin VB.Label Label1 
      Caption         =   "Messages"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   3360
      Width           =   1935
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This program contains the VB code from chapter 11 of the Oracle8i and
' SQL Server 2000 Integration book. While the examples in the book were
' code fragments showing each of the ADO object types, the code in this
' project is complete and can be compiled and run into a separate EXE

Option Explicit
Public oOraConn As ADODB.Connection
Public oSQLConn As ADODB.Connection

Private Sub Form_Load()
  Set oOraConn = New ADODB.Connection
  Set oSQLConn = New ADODB.Connection
End Sub

Function CreateOracleConnection() As ADODB.Connection

  If (oOraConn.State = adStateOpen) Then
     oOraConn.Close
  End If

  oOraConn.Open "Provider=MSDAORA;Data Source = dbalias; " & _
                "User Id = Scott; Password = tiger;"

  Set CreateOracleConnection = oOraConn

End Function

Function CreateSQLServerConnection() As ADODB.Connection

  If (oSQLConn.State = adStateOpen) Then
     oSQLConn.Close
  End If

  oSQLConn.Open "Provider=SQLOLEDB; Server=(local); " & _
                "User Id=sa; Password=;"

  oSQLConn.DefaultDatabase = "Northwind"
  
  Set CreateSQLServerConnection = oSQLConn

End Function


Private Sub UpdateCommand_Click()
  
Dim Cmd As New ADODB.Command

   lbMessages.Clear
  
   Set Cmd.ActiveConnection = CreateOracleConnection()

   Cmd.CommandText = "update emp set sal = sal * 1.10"
  
   lbMessages.AddItem (Cmd.CommandText)
   lbMessages.AddItem ("")
  
   Cmd.CommandType = adCmdText
  
   Cmd.Execute
  
   Dim err As ADODB.Error

   For Each err In Cmd.ActiveConnection.Errors
      lbMessages.AddItem "Error Number: " & err.Number
      lbMessages.AddItem "Description: " & err.Description
      lbMessages.AddItem "Source: " & err.Source
      lbMessages.AddItem "SQL State: " & err.SQLState
      lbMessages.AddItem "Native Error: " & err.NativeError
   Next
    
  ' just to confirm the results, I'll select the records in the emp table
  ' so you can see for yourself.
  
   RecordSet_Click

End Sub

' This procedure updates a SQL Server database using a stored procedure.
' To run this you must create the UpdateProductPrice stored procedure in
' the Northwind database. The definition for this procedure is as follows:
'
' create procedure UpdateProductPrice @ProdID int, @Price money
' AS
' Update Products set UnitPrice = @Price
'  where ProductID = @ProdID
' go

Private Sub UpdateProc_Click()

Dim Cmd As New ADODB.Command
Dim rsProc As New ADODB.RecordSet
Dim parm As ADODB.Parameter
Dim strSQL As String

   lbMessages.Clear
  
   Set Cmd.ActiveConnection = CreateSQLServerConnection()

   Cmd.CommandText = "UpdateProductPrice"
   Cmd.CommandType = adCmdStoredProc
   Cmd.CommandTimeout = 15
       
   ' Set up a new parameters for the stored procedure
   Set parm = Cmd.CreateParameter("ProductID", adInteger, _
                                adParamInput, 4, 38)
   Cmd.Parameters.Append parm

   Set parm = Cmd.CreateParameter("UnitPrice", adCurrency, _
                                adParamInput, 8, 289.64)
   Cmd.Parameters.Append parm

   ' Execute the stored procedure
   Cmd.Execute

   Dim err As ADODB.Error

   For Each err In Cmd.ActiveConnection.Errors
      lbMessages.AddItem "Error Number: " & err.Number
      lbMessages.AddItem "Description: " & err.Description
      lbMessages.AddItem "Source: " & err.Source
      lbMessages.AddItem "SQL State: " & err.SQLState
      lbMessages.AddItem "Native Error: " & err.NativeError
   Next

   strSQL = "select ProductID, ProductName, UnitPrice from Products where ProductID = 38"

   lbMessages.AddItem ("SQL = " & strSQL)
   lbMessages.AddItem ("")
   
   Set rsProc = Cmd.ActiveConnection.Execute(strSQL)

   Do Until rsProc.EOF
      lbMessages.AddItem (CStr(rsProc!ProductID) & "   " & rsProc!ProductName & "   " & CStr(rsProc!UnitPrice))
      rsProc.MoveNext
   Loop

End Sub


Private Sub RecordSet_Click()

Dim rsQueryOne As New ADODB.RecordSet
'Dim rsQueryTwo As New ADODB.RecordSet

Dim oConnection As New ADODB.Connection
Dim strSQL As String

   strSQL = "select empno, ename, sal from emp"

   lbMessages.AddItem ("SQL = " & strSQL)
   lbMessages.AddItem ("")
  
   Set oConnection = CreateOracleConnection

   Set rsQueryOne = oConnection.Execute(strSQL)
  
   ' can also issue use the recordset.open method as shown below.
   ' rsQueryTwo.Open strSQL, oConnection, adOpenForwardOnly, adLockReadOnly
      
   lbMessages.AddItem ("Results from SCOTT.EMP table")
   lbMessages.AddItem ("")

   Do Until rsQueryOne.EOF
      lbMessages.AddItem (CStr(rsQueryOne!empno) & "   " & rsQueryOne!ename & "   " & CStr(rsQueryOne!sal))
      rsQueryOne.MoveNext
   Loop

   lbMessages.AddItem ("")

End Sub

Private Sub RecordSetField_Click()

Dim rsQuery As New ADODB.RecordSet
Dim oConnection As New ADODB.Connection
Dim strSQL As String
Dim fld As ADODB.Field

   lbMessages.Clear

   strSQL = "select empno, ename, sal from emp"

   lbMessages.AddItem ("SQL = " & strSQL)
   lbMessages.AddItem ("")
   
   Set oConnection = CreateOracleConnection

   rsQuery.Open strSQL, oConnection, adOpenForwardOnly, adLockReadOnly

   lbMessages.AddItem ("Results from SCOTT.EMP table")
   lbMessages.AddItem ("")

   Do Until rsQuery.EOF
      lbMessages.AddItem ("Employee Num  : " & CStr(rsQuery.Fields("empno").Value))
      lbMessages.AddItem ("Employee Name : " & rsQuery.Fields("ename").Value)
      lbMessages.AddItem ("Employee Salary : " & CStr(rsQuery.Fields("sal").Value))
      lbMessages.AddItem ("")
      
      rsQuery.MoveNext
   Loop

End Sub

